#include "AudioStack/SMT/clSrcState_RampUp.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//--- Sub-State: RampUp ----------------------------------------------------------------------------
void clSrcState_RampUp::vMsg_OnDone(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOn(), u32UserData);
}

void clSrcState_RampUp::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
}

void clSrcState_RampUp::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

void clSrcState_RampUp::vMsg_On(clAudioSource* pclAudioSource, tU32 )
{


   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On();
   }
}

void clSrcState_RampUp::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // begin sequence again with init
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

}}//namespace


